<?php
// Path to the JSON file
$jsonFile = '../a/rtx/logo_filenames.json';

// Read the JSON file contents
$jsonData = file_get_contents($jsonFile);

// Decode the JSON data
$imageData = json_decode($jsonData, true);

// Extract the filename
$filename = $imageData[0]['ImageName'];

// Define the image file path
$imageFile = "../rtx/logo/" . "$filename";

// Output the HTML with embedded CSS for background image
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Background Image</title>
    <style>
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            overflow: hidden;
        }
        body {
            background-image: url("<?php echo $imageFile; ?>");
            background-size: cover; /* Faz a imagem cobrir toda a área */
            background-position: center; /* Centraliza a imagem */
            background-repeat: no-repeat; /* Não repete a imagem */
        }
    </style>
</head>
<body>
</body>
</html>