<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}
ini_set('display_errors', 0);
include('includes/header.php');

$hetnoteFilePath = './api/msg.php';

$currentRecord = '';

if (file_exists($hetnoteFilePath)) {
    // Lê o conteúdo do arquivo getnote.php
    $fileContent = file_get_contents($hetnoteFilePath);
    // Extrai o conteúdo entre <!--new_texto--> e o próximo fechamento da div
    if (preg_match('/<!--new_texto-->(.*?)<\/div>/s', $fileContent, $matches)) {
        $currentRecord = trim($matches[1]);
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['updateButton'])) {
        $currentRecord = $_POST['first_message'];
        // Substitui <!--new_texto--> pelo novo conteúdo
        $newContent = preg_replace('/<!--new_texto-->.*?<\/div>/s', '<!--new_texto-->' . $currentRecord . '</div>', $fileContent);
        file_put_contents($hetnoteFilePath, $newContent);
        echo "<p>Record has been updated successfully!</p>";
    } elseif (isset($_POST['clearButton'])) {
        $currentRecord = '';
        // Substitui <!--new_texto--> por uma string vazia
        $newContent = preg_replace('/<!--new_texto-->.*?<\/div>/s', '<!--new_texto--></div>', $fileContent);
        file_put_contents($hetnoteFilePath, $newContent);
        echo "<p>All records have been cleared!</p>";
    }
}
?>

<div class="col-md-6 mx-auto">
    <div class="card-body">
        <div class="card bg-primary text-white">
            <div class="card-header">
                <center>
                    <h2><i class="fa fa-commenting"></i> Notification </h2>
                </center>
            </div>
            <div class="card-body">
                <form method="post">
                    <label for="first_message">Title:</label>
                    <div class="form-group">
                        <input type="text" class="form-control" name="first_message" value="<?php echo htmlspecialchars($currentRecord); ?>" required>
                    </div>
                    <input type="submit" class="custom-button btn btn-success btn-icon-split" name="updateButton" value="Save and Update">
                    <input type="submit" class="custom-button btn btn-danger btn-icon-split" name="clearButton" value="Clear Messages">
                </form>
            </div>
        </div>
    </div>
</div>

<?php include('includes/footer.php'); ?>
</body>
</html>
