<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}
error_reporting(0);
include "includes/header.php";
$jsonFilePath = 'includes/ad_type.json';
$jsonData = json_decode(file_get_contents($jsonFilePath), true);
$currentAdType = $jsonData['adType'] ?? 'manual'; 
$db = new SQLite3("./api/.bet_tmdb.db");
$table_name = "api_key";
$db->exec("CREATE TABLE IF NOT EXISTS " . $table_name . " (id INTEGER PRIMARY KEY, key TEXT)");

$rows = $db->query("SELECT COUNT(*) as count FROM " . $table_name);
$row = $rows->fetchArray();
$numRows = $row["count"];

if ($numRows == 0) {
    $db->exec("INSERT INTO " . $table_name . "(key) VALUES('')");
	
	
}



if ($_SERVER["REQUEST_METHOD"] === "POST") {
    if (isset($_POST["submit"])) {
        $newKey = $_POST["key"]; // No validation/sanitization here for demonstration purposes

        // Use prepared statements to prevent SQL injection
        $stmt = $db->prepare("UPDATE " . $table_name . " SET key = :newKey WHERE id = 1");
        $stmt->bindValue(':newKey', $newKey, SQLITE3_TEXT);
        $stmt->execute();

        header("Location: tmdb_api_itech.php");
        exit();
    
    } elseif (isset($_POST["deleteCache"])) {
        // Specify the path to your JSON cache file
        $cacheFilePath = "./api/cache/combined_cache.json";

        // Check if the cache file exists and delete it
        if (file_exists($cacheFilePath)) {
            unlink($cacheFilePath); // Delete the cache file
        }

        // Redirect and exit

        header("Location: tmdb_api_itech.php");
        exit();
    }
}

$res = $db->query("SELECT * FROM " . $table_name . " WHERE id = 1");
$rowU = $res->fetchArray();


if (empty($rowU['key'])) {
    echo '<div class="alert alert-warning" role="alert">
        You must add your tMDB API key before using the app. Follow the instructions below to add your API key.
    </div>';
} 

?>
<link rel="stylesheet" href="css/slider.css">
        <div class="col-md-12 mx-auto">
            <div class="card-body">
                
                <div class="card bg-primary text-white">
                    <div class="card-header card-header-warning">
                                    <div class="card-header bg-primary py-3">
                                        
                                        <div id="slider-container" data-ad-type="<?php echo $currentAdType; ?>" style="display: flex; align-items: center; justify-content: center;">
    <span style="margin-right: 20px; font-size: 24px;">ADS Manual</span> <!-- Increased font size here -->
    <label class="switch">
        <input type="checkbox" id="pageSlider" onchange="toggleAdType()">
        <span class="slider round"></span>
    </label>
    <span style="margin-left: 20px; font-size: 24px;">tMDB Ads</span> <!-- And here -->
</div>
                            <center>
                            <h5> Selecione o tipo de ADS</h5>
                            </center>
                                    </div>
                                    <div class="card-body">
                                        <!-- Add instructions here -->
                                        <p style="font-size: 16px;">
                                            Para usar este aplicativo, você precisa ter uma chave API tMDB. Siga estas etapas para obter sua chave API:
                                        </p>
                                        <ol>
                                            <li>Visite o site do tMDB <a href="https://www.themoviedb.org" target="_blank" style="font-weight: bold; color: #007bff; text-decoration: underline;">https://www.themoviedb.org/</a></li>
                                            <li>Faça login ou crie uma conta se ainda não tiver uma.</li>
                                            <li>Para registrar uma chave de API, clique no botão <a href="https://www.themoviedb.org/settings/api" target="_blank" style="font-weight: bold; color: #007bff; text-decoration: underline;">link da API</a> na página de configurações da sua conta.</li>

                                            <li>
                                                Observe que o processo de registro da API não é otimizado para dispositivos móveis, portanto você deve acessar essas páginas em um computador desktop e navegador
                                            </li>
                                            <li>Gere uma nova chave de API e copie-a.</li>
                                        </ol>
                                        <p>
                                            Cole a chave API copiada no campo abaixo e clique no botão "Salvar configurações".
                                        </p>
                                        <!-- End of instructions -->

                                        <form method="post">
                                            <div class="form-group mb-3">
                                                <label class="control-label text-primary" for="key">
                                                    <strong>Api key:</strong>
                                                </label>
                                                <div class="input-group">
                                                    <input class="form-control" id="key" name="key" value="<?= $rowU['key']; ?>" type="text" />
                                                </div>
                                            </div>
                                            <div align="center" class="form-group mb-3">
                                                <br>
                                                <div>
                                                    <button class="btn btn-success" name="submit" type="submit">
                                                        <span class="icon text-white-50"><i class="fa fa-save"></i>&nbsp;&nbsp;</span>
                                                        <span class="text">Salvar configurações</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                 <!-- Add the "Delete Cache" button -->
                    <form method="post">
                        <div align="center" class="form-group mb-3">
                            <button class="btn btn-danger" name="deleteCache" type="submit">
                                <span class="icon text-white-50"><i class="fa fa-trash"></i>&nbsp;&nbsp;</span>
                                <span class="text">Apagar Cache</span>
                            </button>
                        </div>
                    </form>
                </div>
                    <!-- ============================================================== -->
                    <!-- End Container fluid  -->
                    <!-- ============================================================== -->
                </div>
                <!-- ============================================================== -->
                <!-- End Page wrapper  -->
                <!-- ============================================================== -->
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    var sliderContainer = document.getElementById('slider-container');
    var currentAdType = sliderContainer.getAttribute('data-ad-type');
    var slider = document.getElementById('pageSlider');

    // Set the slider based on the ad type from JSON
    slider.checked = (currentAdType === 'tmdb');

    slider.addEventListener('change', function() {
        var adType = this.checked ? 'tmdb' : 'manual';
        updateAdType(adType);
    });
});

function updateAdType(adType, isChecked) {
    var xhr = new XMLHttpRequest();
    xhr.open('POST', 'ad_type.php', true);
    xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        // Redirect to the appropriate page based on the slider's position
        window.location.href = isChecked ? 'tmdb_api_itech.php' : 'ads_itech.php';
    };
    xhr.send('adType=' + adType);
}
</script>
<?php include "includes/functions.php"; ?>
