
<!DOCTYPE html>
<html>
<head>
    <style>
        /* Reset default margin and padding for all elements */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box; /* Include padding and border in the element's total width and height */
        }

        /* Apply styles to the body element */
        body {
            display: flex;
            justify-content: center; /* Center items horizontally */
            align-items: center; /* Center items vertically */
            width: 100vw;
            height: 100vh;
            background-size: 100% 100%;
            background-repeat: no-repeat;
            color: white; /* Set default text color */
            overflow: hidden; /* Hide the scrollbar */
        }

        /* Apply styles to the container div */
        .container {
            display: flex;
            flex-direction: row; /* Arrange items horizontally */
            width: 100%; /* Full width of the viewport */
            height: 100vh; /* Full height of the viewport */
            justify-content: space-between; /* Space out items evenly */
            align-items: center; /* Center items vertically */
            padding: 10px; /* Add padding */
        }

        /* Apply styles to the QR Code container */
        .qrcode {
            padding-right: 10px; /* Add some space to the right of the QR Code */
            display: flex; /* Use flexbox to center the QR Code vertically */
            justify-content: center; /* Center the QR Code horizontally */
            align-items: center; /* Center the QR Code vertically */
        }

        #qrcode-img {
            height: auto;
            width: 25px; /* Adjust width as needed */
        }

        .title-content {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
        }
        
        .message-container {
            display: flex;
            margin-left: 10px;
            justify-content: flex-end; /* Align text container to the right */
            align-items: center; /* Center vertically */
            flex-grow: 1; /* Allow to grow to use available space */
            overflow: hidden; /* Hide overflow */
        }

        .message-title {
            font-size: 10px;
            text-transform: uppercase;
            font-weight: bold;
            white-space: pre-wrap; /* Preserve whitespace for new lines */
        }

        .message-description {
            font-size: 15px;
            font-weight: bold;
            display: inline-block;
            white-space: nowrap;
            text-transform: uppercase;
            animation: marquee 1.5s linear infinite; /* Apply marquee animation */
        }

    </style>
</head>
<body bgcolor="transparent">

<!-- Status: 1 --><div class="container">
    <div class="qrcode">
            <img id="qrcode-img" src="../assets/images/bell_icon.png">
    </div>

    <div class="title-content">
        <h2 class="message-title">Avisos<br>Servidor</h2>
    </div>

    <div class="message-container">

            <marquee class="message-description">No esquea de Renovar sua Assinatura!!</marquee>
        
    </div>
</div>

</body>
</html>