<?php
session_start();

if (isset($_POST['access_code'])) {
    $access_code = $_POST['access_code'];

    // URL para verificar o token
    $token_url = "https://token.boxtv.store/tokenatlas.php=$access_code";

    // Inicializa o cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $token_url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    // Executa a requisição e armazena a resposta
    $response = curl_exec($ch);
    curl_close($ch);

    if ($response === "valid") {
        $_SESSION['access_granted'] = true;
        header('Location: add.php');
        exit();
    } else {
        $error = "Código de acesso inválido!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Access Code</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f7f7f7;
        }
        .modal {
            display: block;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgb(0,0,0);
            background-color: rgba(0,0,0,0.4);
            padding-top: 60px;
        }
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 400px;
            border-radius: 8px;
        }
        .modal-content h2 {
            margin-bottom: 20px;
        }
        .modal-content form {
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .modal-content input {
            font-size: 20px;
            text-align: center;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 4px;
            padding: 10px;
            width: 80%;
        }
        .modal-content button {
            background-color: #4CAF50;
            color: white;
            border: none;
            border-radius: 4px;
            padding: 10px 20px;
            cursor: pointer;
        }
        .modal-content button:hover {
            background-color: #45a049;
        }
        .modal-content p {
            color: red;
        }
    </style>
</head>
<body>
    <div id="accessModal" class="modal">
        <div class="modal-content">
            <h2>Digite o código de acesso</h2>
            <form method="post">
                <input type="text" name="access_code" placeholder="Código de Acesso" maxlength="6" required>
                <button type="submit">Acessar</button>
            </form>
            <?php if (isset($error)) { echo "<p>$error</p>"; } ?>
        </div>
    </div>
</body>
</html>
